# PHOTO-015: Docs Tab Expansion — All Document Types in Mobile App

## Status: READY TO DEPLOY

## Problem
The mobile app's Documents tab only showed `permit_files` with `type='newtr_swhdocuments'`. The scheduler has 5 document tables (sketch_files, genral_files, presale_files, predesignsketch_files, permit_files) — none visible in the app except one narrow permit type.

Additionally, 3 bugs existed:
- **Upload typo**: `uploaddoc()` wrote `type='newtr_swhdocumnets'` (misspelled) but listing read `'newtr_swhdocuments'` — uploaded docs never appeared
- **Customer docs pfid bug**: `customerdocstabstate()` used `$job['jfid']` (undefined) instead of `$job['pfid']`
- **Auth disabled on upload**: token check commented out in `uploaddoc()`

## Changes Made

**File**: `loginapinew.php` (photoappsch controller)

### 1. Expanded `customerdocstabdetails($job_id)` (~line 1191)
- Replaced single `permit_files WHERE type='newtr_swhdocuments'` query with UNION ALL across all 5 document tables
- Each row gets prefixed ID (pf_, sf_, gf_, ps_, pd_) to identify source table
- Added `docCategory` and `fileName` fields to response JSON (additive, app ignores unknown fields)
- Added `GROUP BY` per sub-select to prevent duplicate rows from sibling job joins

### 2. Expanded `getcustomerdoc($pfid)` (~line 1688)
- Parses prefix to determine source table (sf_123 → sketch_files id=123)
- Plain integers still route to permit_files for backwards compatibility
- All tables use same `new_filename` / `original_filename` columns, so file streaming logic unchanged

### 3. Fixed upload typo in `uploaddoc()` (~line 1568)
- Changed `'type' => 'newtr_swhdocumnets'` to `'type' => 'newtr_swhdocuments'`

### 4. Fixed pfid bug in `customerdocstabstate()` (line 687)
- Changed `$job['jfid']` to `$job['pfid']`

### 5. Re-enabled auth on `uploaddoc()` (~line 1486)
- Uncommented and rewired token validation using same pattern as other functions

## Prefix Mapping

| Prefix | Table | Doc Category |
|--------|-------|-------------|
| `pf` | `permit_files` | Varies by `type` column |
| `sf` | `sketch_files` | Sales Sketch |
| `gf` | `genral_files` | Project Design / General |
| `ps` | `presale_files` | Pre-Sale Document |
| `pd` | `predesignsketch_files` | Pre-Design Sketch |
| (none) | `permit_files` | Backwards compatibility |

## No App Changes Required
- Flutter app treats `pfid` as `String?` — prefixed IDs pass through unchanged
- App ignores unknown JSON fields — `docCategory` and `fileName` are additive
- Download URL built via string interpolation: `getcustomerdoc/$pfid`

## Deployment

```bash
# 1. Backup on remote
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 \
  "sudo cp /var/www/vhosts/aeihawaii.com/httpdocs/photoappsch/system/application/controllers/loginapinew.php \
   /var/www/vhosts/aeihawaii.com/httpdocs/photoappsch/system/application/controllers/loginapinew.php.bak.pre_enh015.20260219"

# 2. SCP and deploy
scp -i /root/.ssh/aei_remote.pem \
  /var/opt/AEI_REMOTE/AEI_PHOTO_API_PROJECT/ENHANCEMENTS/PHOTO-015_DOCS_TAB_EXPANSION/NEW/loginapinew.php \
  Julian@18.225.0.90:/tmp/loginapinew.php

ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 \
  "sudo cp /tmp/loginapinew.php /var/www/vhosts/aeihawaii.com/httpdocs/photoappsch/system/application/controllers/loginapinew.php && \
   sudo chown ec2-user:ec2-user /var/www/vhosts/aeihawaii.com/httpdocs/photoappsch/system/application/controllers/loginapinew.php"
```

## Rollback

```bash
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 \
  "sudo cp /var/www/vhosts/aeihawaii.com/httpdocs/photoappsch/system/application/controllers/loginapinew.php.bak.pre_enh015.20260219 \
   /var/www/vhosts/aeihawaii.com/httpdocs/photoappsch/system/application/controllers/loginapinew.php"
```

## Verification

1. `customerdocstabdetails/108806` — should return docs from all 5 tables with prefixed pfids
2. `getcustomerdoc/sf_3897` — should serve a sketch file
3. `getcustomerdoc/pf_8667` — should serve a permit file
4. `getcustomerdoc/8667` (no prefix) — backwards compat, should still work
5. `uploaddoc` — verify type is now `newtr_swhdocuments` (correct spelling)
6. `customerdocstabstate/{customer_id}` — verify pfid is populated (not null)
